<?php
# Author: Michael Langevin
/**
 * MIT License
 * 
 * Copyright (c) 2025 Michael Langevin
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

// INSERT API KEY and SERVER on LINE 57 and 58 in ajax.php
// INSERT API KEY and SERVER on LINE 57 and 58 in ajax.php
// INSERT API KEY and SERVER on LINE 57 and 58 in ajax.php
// INSERT API KEY and SERVER on LINE 57 and 58 in ajax.php
// INSERT API KEY and SERVER on LINE 57 and 58 in ajax.php

include_once(dirname(__FILE__) . '/../dashlethelper.inc.php');

cryptograph_dashlet_init();

function cryptograph_dashlet_init()
{
    $name = "CryptoGraph_Dashlet";

    $args = array(
        DASHLET_NAME            => $name,
        DASHLET_VERSION         => "1.1.0",
        DASHLET_DATE            => "2025-10-13",
        DASHLET_AUTHOR          => "Michael Langevin",
        DASHLET_DESCRIPTION     => _("Displays a cryptocurrency graph overlaid with a Nagios service metric."),
        DASHLET_COPYRIGHT       => "Copyright (c) 2025",
        DASHLET_LICENSE         => "BSD",
        DASHLET_HOMEPAGE        => "https://www.nagios.com",
        DASHLET_FUNCTION        => "cryptograph_dashlet_func",
        DASHLET_REFRESHRATE     => 300,
        //DASHLET_FILTER_GROUPS   => array("monitoring", "finance"),
        DASHLET_TITLE           => _("Crypto vs Metric"),
        DASHLET_WIDTH           => "400",
        DASHLET_HEIGHT          => "250",
        DASHLET_OPACITY         => "1.0"
    );

    register_dashlet($name, $args);
}

function cryptograph_dashlet_func($mode = DASHLET_MODE_PREVIEW, $id = "", $args = null)
{
    $output = "";
    $base_url = get_base_url() . "includes/dashlets/cryptograph_dashlet/";

    switch ($mode) {

        case DASHLET_MODE_GETCONFIGHTML:
            $output = ''; // No configuration form yet
            break;

        case DASHLET_MODE_OUTBOARD:
        case DASHLET_MODE_INBOARD:
            if ($id == "")
                $id = "cryptograph_dashlet_" . random_string(6);

            $nsp = get_nagios_session_protector_id();
            $output .= "
            <div id='{$id}' class='cryptograph-dashlet-container' style='width:100%;height:100%;'></div>
            <script type='text/javascript'>
                function load_cryptograph_dashlet_{$id}() {
                    var url = '{$base_url}ajax.php?mode=getcontent&container={$id}&nsp={$nsp}';
                    jQuery('#{$id}').load(url);
                }
                load_cryptograph_dashlet_{$id}();
            </script>";
            break;

        case DASHLET_MODE_PREVIEW:
            $output = "
                <div style='padding:12px; font-family:Arial; text-align:center;'>
                    <img src='{$base_url}preview.png' alt='Preview Image' style='max-width:100%; height:auto; margin-top:10px; border:1px solid #ccc;' />
                    <strong>Crypto vs System Metric Dashlet</strong>
                    <p>Overlay cryptocurrency trends with a Nagios Alert.</p>
                </div>";
            break;
    }

    return $output;
}
?>
