#!/usr/bin/perl -w

# By Alexander Silverö 2012-12-10
# cocoon.is@gmail.com
# see ./scriptname -help for information on how to use this script.
# check freeradius daemon by using radclient for a auth|acct|status reply.
# %ERRORS=('OK'=>0,'WARNING'=>1,'CRITICAL'=>2,'UNKNOWN'=>3,'DEPENDENT'=>4);
# exit($ERRORS{'UNKNOWN'});
# 2013-08-09
# Updated after a suggestion by Rune Nilssen <rune@nexthop.no> 
# Thanks for the suggestion Rune!

use POSIX;
use strict;
use Getopt::Long;
use Time::HiRes qw(gettimeofday tv_interval);
use lib "/usr/local/nagios/libexec";
#use lib utils.pm;
use utils qw(%ERRORS &print_revision &support &usage);

# Globals
our($SCRIPT, $VERSION, %OPTS, $function_flag, $h_flag, $p_flag, $t_flag, $s_flag, $r_flag, $rv_flag, $rc_flag, $w_flag, $c_flag, $deli_flag, $help_flag, $d_flag, $v_flag);

$SCRIPT = "check_freeradius.pl";
$VERSION = "1.0.2";

GetOptions ("f|FUN|FUNCTION:s" => \$function_flag,
		"h|HOST:s" => \$h_flag,
                "p|PORT:s" => \$p_flag,
		"t|TIME|TIMEOUT:s" => \$t_flag,
		"s|SECRET:s" => \$s_flag,
		"r|RAD|RADIUS|RADIUSATTRIBUTES:s" => \$r_flag,
		"a|ATTRIBUTE|ATTRIBUTESVALUES:s" => \$rv_flag,
		"cl|CLIENT:s" => \$rc_flag,
                "w|warn|warning:o" => \$w_flag,
                "c|crit|critical:o" => \$c_flag,
		"del|delimiter:s" => \$deli_flag,
                "v|version" => \$v_flag,
                "help" => \$help_flag,
                "d|debug" => \$d_flag);

my $FUNCTION = $function_flag;
my $HOST = $h_flag;
my $PORT = $p_flag;
my $TIMEOUT = $t_flag;
my $RADIUS_SECRET = $s_flag;
my $RAD_ATTRIBUTES_LIST = $r_flag;
my $RAD_ATTRIBUTES_VALUES = $rv_flag;
my $RAD_CLIENT = $rc_flag;
my $WARNING_THRESHOLD = $w_flag;
my $CRITICAL_THRESHOLD = $c_flag;
my $DELIMITER = $deli_flag;
my $VERSIONFLAG = $v_flag;
my $DEBUG = $d_flag;
my $HELP = $help_flag;



###################################
### Other Variables here	###
###################################
my $RADCLIENT_CMD1 = "";
my $RADCLIENT_CMD2 = "";
my $t0;
my $elapsed;

my $RADIUS_RESENDS = "1";
my $RADIUS_SENDS = "1";

my @RADIUS_ATTRIBUTES;
my @RADIUS_ATTRIBUTES_VALUES;
my $RAD_ATTRIBUTES_LIST_AND_VALUES;
my $arrayLength = 0;
my $arrayLengthList = 0;
my $arrayLengthValues = 0;
my $ListNValuesStatus = 0;

my $STATUS;

my $i = 0;
my $y = 0;


#my %ERRORS = ('OK'=>0,'WARNING'=>1,'CRITICAL'=>2,'UNKNOWN'=>3,'DEPENDENT'=>4);

if ($DEBUG)
{
	if (!$HELP){$HELP = 0};	
	if (!$DELIMITER){$DELIMITER = 0};
	
	printf("\nDEBUG: Passed in variables was: FUNCTION = $FUNCTION, HOST = $HOST, PORT = $PORT, TIMEOUT = $TIMEOUT, RADIUS_SECRET = $RADIUS_SECRET, RAD_ATTRIBUTES_LIST = $RAD_ATTRIBUTES_LIST, RAD_ATTRIBUTES_VALUES = $RAD_ATTRIBUTES_VALUES, RAD_CLIENT = $RAD_CLIENT, WARNING_THRESHOLD = $WARNING_THRESHOLD, CRITICAL_THRESHOLD = $CRITICAL_THRESHOLD, DELIMITER = $DELIMITER, DEBUG = $DEBUG, HELP = $HELP");
}
##############################
### Some Default behaviour ###
##############################

if ($VERSIONFLAG)
{
        printf ("$VERSION\n");
        exit;
} 
if ($HELP)
{
        _usage();
}
if (!$FUNCTION)
{
        if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -function input supplied to script!! Using default -function auth..\n");
        }
	_usage();
        #$FUNCTION = "auth";
}
if (!$HOST)
{
        if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -HOST input supplied to script!! Using default -HOST localhost..\n");
        }
        $HOST = "localhost";
}
if (!$PORT)
{
        if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -PORT input supplied to script!! Using default -PORT 1812..\n");
        }
        $PORT = "localhost";
}
if (!$RADIUS_SECRET)
{
	if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -SECRET input supplied to script!! Using default -SECRET testing123..\n");
        }
        $RADIUS_SECRET = "testing123";
}
if ( (!$TIMEOUT) || ($TIMEOUT !~ /^\d+$/))
{
        if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -TIMEOUT input is missing or in wrong format!! Using default -TIMEOUT 8 sec..\n");
        }
        $TIMEOUT = "8";
}
if (!$RAD_CLIENT)
{
	if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -Radius clients input supplied to script !! Using default --CLIENT /usr/bin/radclient..\n");
        }
	$RAD_CLIENT = "/usr/bin/radclient";
}
#if ( (!$WARNING_THRESHOLD) || ($WARNING_THRESHOLD !~ /^\d+$/) || ($WARNING_THRESHOLD <= 0) ) 
if ( (!$WARNING_THRESHOLD) || ($WARNING_THRESHOLD <= 0) )
{
	if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -WARNING Threshold input is missing or in wrong format!! Using default --WARNING 3 sec..\n");
        }
	$WARNING_THRESHOLD = "3";
}
#if ( (!$CRITICAL_THRESHOLD) || ($CRITICAL_THRESHOLD !~ /^\d+$/) || ($CRITICAL_THRESHOLD <= 0) )
if ( (!$CRITICAL_THRESHOLD) || ($CRITICAL_THRESHOLD <= 0) )
{
	if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -CRITICAL Threshold input is missing or in wrong format !! Using default --CRITICAL 8 sec..\n");
        }
	$CRITICAL_THRESHOLD = "8";
}
if (!$DELIMITER)
{
	if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -DELIMITER input supplied to script !! Using default --delimiter \",\"..\n");
        }
	$DELIMITER = ",";
}
if ( (!$RAD_ATTRIBUTES_LIST) || (!$RAD_ATTRIBUTES_VALUES) )
{
	if ($DEBUG)
        {
                printf("\nINFORMATIVE: No -ATTRIBUTE or -VALUES input supplied to script!! Using default -ATTRIBUTE Message-Authenticator..\n");
        }
	$RAD_ATTRIBUTES_LIST = "Message-Authenticator";
	$RAD_ATTRIBUTES_VALUES = "0x00";
}
else
{

	@RADIUS_ATTRIBUTES = split(/$DELIMITER/, $RAD_ATTRIBUTES_LIST);
	@RADIUS_ATTRIBUTES_VALUES = split(/$DELIMITER/, $RAD_ATTRIBUTES_VALUES);
	$arrayLength = @RADIUS_ATTRIBUTES;
	$arrayLengthValues = @RADIUS_ATTRIBUTES_VALUES;

	if ($DEBUG)
	{
		printf("\nDEBUG: arrayLength = $arrayLength, arrayLengthValues = $arrayLengthValues");
	}
	if ( ("$arrayLength" eq "$arrayLengthValues") )
	{
		$ListNValuesStatus = 1;
	}
	else
	{
		if ($DEBUG)
        	{
                	printf("\nINFORMATIVE: No -ATTRIBUTE input and -VALUES input supplied to script is not consistent !! Using default -ATTRIBUTE Message-Authenticator..\n");
			printf("\nDEBUG: RADIUS_ATTRIBUTES = @RADIUS_ATTRIBUTES\nRADIUS_ATTRIBUTES_VALUES = @RADIUS_ATTRIBUTES_VALUES");
        	}

		$RAD_ATTRIBUTES_LIST = "Message-Authenticator";
		$RAD_ATTRIBUTES_VALUES = "0x00";
	}
	
	
}


#############################
### Main we run from here ###
#############################
if ( ($FUNCTION =~ /au|AUTHENTICATION/i) )
{
	if (!$ListNValuesStatus)
	{
		$FUNCTION = "status";
	}
	else
	{
		$FUNCTION = "auth";
	}

	if ($ListNValuesStatus)
	{

		while ( $i < @RADIUS_ATTRIBUTES)
		{
			$RAD_ATTRIBUTES_LIST_AND_VALUES .= ("$RADIUS_ATTRIBUTES[$i] = '$RADIUS_ATTRIBUTES_VALUES[$i]', ");
			if ($DEBUG)
			{
				printf("\nDEBUG: RAD_ATTRIBUTES_LIST_AND_VALUES = $RAD_ATTRIBUTES_LIST_AND_VALUES\nRADIUS_ATTRIBUTES[$i] = $RADIUS_ATTRIBUTES[$i], RADIUS_ATTRIBUTES_VALUES[$i] = $RADIUS_ATTRIBUTES_VALUES[$i]");
			}
			$i++;
		}
		chop $RAD_ATTRIBUTES_LIST_AND_VALUES;
		chop $RAD_ATTRIBUTES_LIST_AND_VALUES;
		$RADCLIENT_CMD1 = ("echo \"$RAD_ATTRIBUTES_LIST_AND_VALUES\" | $RAD_CLIENT -q -c $RADIUS_SENDS -r $RADIUS_RESENDS -t $TIMEOUT $HOST:$PORT $FUNCTION $RADIUS_SECRET");
		if ($DEBUG)
                {
                        printf("\nDEBUG: After insertion: RAD_ATTRIBUTES_LIST_AND_VALUES = $RAD_ATTRIBUTES_LIST_AND_VALUES\n");
			printf("DEBUG: radclient command to send: $RADCLIENT_CMD1\n");
                }      
	}
	else
	{
		$RADCLIENT_CMD1 = ("echo \"$RAD_ATTRIBUTES_LIST = '$RAD_ATTRIBUTES_VALUES'\" | $RAD_CLIENT -q -c  $RADIUS_SENDS -r $RADIUS_RESENDS -t $TIMEOUT $HOST:$PORT $FUNCTION $RADIUS_SECRET");
	#"echo \"Message-Authenticator = 0x00\" | $radclient -q -c 1 -r 1 -t $t $host:$port status $secret 2>/dev/null";

		if ($DEBUG)
        	{
                	printf("\nDEBUG: radclient command to send: $RADCLIENT_CMD1\n");
        	}
	}
	$t0 = [gettimeofday];
	system($RADCLIENT_CMD1);
	$elapsed = tv_interval($t0);

	##############################################
	### For testing of below cases change here ###
	##############################################
	#$elapsed = 3;
	if ( ($elapsed >= $CRITICAL_THRESHOLD) || ($? !=0) )
         {
                 $STATUS = $ERRORS{'CRITICAL'};
                 printf("CRITICAL: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;
         }
         elsif ( ($elapsed < $WARNING_THRESHOLD ) )
         {
                 $STATUS = $ERRORS{'OK'};
                 printf("OK: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;


         }
         elsif ( ($elapsed >= $WARNING_THRESHOLD) )
         {
                 $STATUS = $ERRORS{'WARNING'};
                 printf("WARNING: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;
         }
         else
         {
                 $STATUS = $ERRORS{'UNKNOWN'};
                 printf("CRITICAL: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;
         }


}
elsif ( ($FUNCTION =~ /ac|ACCOUNTING/i) )
{
        if (!$ListNValuesStatus)
        {
                $FUNCTION = "status";
        }
        else
        {
                $FUNCTION = "acct";
        }

        if ($ListNValuesStatus)
        {

                while ( $i < @RADIUS_ATTRIBUTES)
                {
                        $RAD_ATTRIBUTES_LIST_AND_VALUES .= ("$RADIUS_ATTRIBUTES[$i] = '$RADIUS_ATTRIBUTES_VALUES[$i]', ");
                        if ($DEBUG)
                        {
                                printf("\nDEBUG: RAD_ATTRIBUTES_LIST_AND_VALUES = $RAD_ATTRIBUTES_LIST_AND_VALUES\nRADIUS_ATTRIBUTES[$i] = $RADIUS_ATTRIBUTES[$i], RADIUS_ATTRIBUTES_VALUES[$i] = $RADIUS_ATTRIBUTES_VALUES[$i]");
                        }
                        $i++;
                }
                chop $RAD_ATTRIBUTES_LIST_AND_VALUES;
                chop $RAD_ATTRIBUTES_LIST_AND_VALUES;
                $RADCLIENT_CMD1 = ("echo \"$RAD_ATTRIBUTES_LIST_AND_VALUES\" | $RAD_CLIENT -q -c  $RADIUS_SENDS -r $RADIUS_RESENDS -t $TIMEOUT $HOST:$PORT $FUNCTION $RADIUS_SECRET");
                if ($DEBUG)
                {
                        printf("\nDEBUG: After insertion: RAD_ATTRIBUTES_LIST_AND_VALUES = $RAD_ATTRIBUTES_LIST_AND_VALUES\n");
                        printf("DEBUG: radclient command to send: $RADCLIENT_CMD1\n");
                }      
        }
        else
        {
                $RADCLIENT_CMD1 = ("echo \"$RAD_ATTRIBUTES_LIST = '$RAD_ATTRIBUTES_VALUES'\" | $RAD_CLIENT -q -c  $RADIUS_SENDS -r $RADIUS_RESENDS -t $TIMEOUT $HOST:$PORT $FUNCTION $RADIUS_SECRET");
        #"echo \"Message-Authenticator = 0x00\" | $radclient -q -c 1 -r 1 -t $t $host:$port status $secret 2>/dev/null";

                if ($DEBUG)
                {
                        printf("\nDEBUG: radclient command to send: $RADCLIENT_CMD1\n");
                }
        }
        $t0 = [gettimeofday];
        system($RADCLIENT_CMD1);
        $elapsed = tv_interval($t0);

        ##############################################
        ### For testing of below cases change here ###
        ##############################################
        #$elapsed = 3;

	if ( ($elapsed >= $CRITICAL_THRESHOLD) || ($? !=0) )
         {
                 $STATUS = $ERRORS{'CRITICAL'};
                 printf("CRITICAL: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;
         }
         elsif ( ($elapsed < $WARNING_THRESHOLD ) )
         {
                 $STATUS = $ERRORS{'OK'};
                 printf("OK: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;


         }
         elsif ( ($elapsed >= $WARNING_THRESHOLD) )
         {
                 $STATUS = $ERRORS{'WARNING'};
                 printf("WARNING: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;
         }
         else
         {
                 $STATUS = $ERRORS{'UNKNOWN'};
                 printf("CRITICAL: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;
         }
}
elsif ( ($FUNCTION =~ /s|status/i) )
{

	$FUNCTION = "status";
   
   
	$RADCLIENT_CMD1 = ("echo \"Message-Authenticator = '0x00'\" | $RAD_CLIENT -q -c  $RADIUS_SENDS -r $RADIUS_RESENDS -t $TIMEOUT -s $HOST:$PORT $FUNCTION $RADIUS_SECRET");
        #"echo \"Message-Authenticator = 0x00\" | $radclient -q -c 1 -r 1 -t $t $host:$port status $secret 2>/dev/null";

        if ($DEBUG)
        {
        	printf("\nDEBUG: radclient command to send: $RADCLIENT_CMD1\n");
        }
        $t0 = [gettimeofday];
        system($RADCLIENT_CMD1);
        $elapsed = tv_interval($t0);

        ##############################################
        ### For testing of below cases change here ###
        ##############################################
        #$elapsed = 3;

	if ( ($elapsed >= $CRITICAL_THRESHOLD) || ($? !=0) )
         {
                 $STATUS = $ERRORS{'CRITICAL'};
                 printf("CRITICAL: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;
         }
         elsif ( ($elapsed < $WARNING_THRESHOLD ) )
         {
                 $STATUS = $ERRORS{'OK'};
                 printf("OK: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;


         }
         elsif ( ($elapsed >= $WARNING_THRESHOLD) )
         {
                 $STATUS = $ERRORS{'WARNING'};
                 printf("WARNING: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;
         }
         else
         {
                 $STATUS = $ERRORS{'UNKNOWN'};
                 printf("CRITICAL: Radius respons time: $elapsed secs, warning threshold: $WARNING_THRESHOLD, critical threshold: $CRITICAL_THRESHOLD, radclient exit status: $?, $SCRIPT exit STATUS: $STATUS.");
                 exit $STATUS;
         }

}
else
{
	printf("ERROR: Unknown functions, please read help for instructions on how to use this program");
	_usage();
}

###########################
### Functions here	###
###########################


sub _usage
{
print << "USAGE"; 
\n$SCRIPT $VERSION
Usage: $SCRIPT	-|--f|F|FUN|function|FUNCTION <auth|acct|status|> -|--h|H|host|HOST <IP to radius server> -|--p|P|port|PORT <listening port for radius server> 
		-|--t|T|time|TIME|timeout <timeout> -|--s|S|secret|SECRET <password for radius database> -|--cl|CL|client|CLIENT <path to radclient>
		-|--r|R|rad|RAD|radius|RADIUS|radiusattributes|RADIUSATTRIBUTES <string of comma separated radius attributes> 		
		-|--a|A|attribute|ATTRIBUTE|attributevalues|ATTRIBUTESVALUES <string of comma separated radius attributes values>
		-|--del|delimiter <delimiter to use if default comma is used in radius attribute VALUES>
		-|--w|W|warn|WARN|warning|WARNING <Warning radius reply threshold in secs>
		-|--c|C|crit|CRIT|critical|CRITICAL <Warning radius reply threshold in secs>
		-|--v|V|VERSION |version -|--he|HE|help|HELP -|--d|D|DEBUG|debug <debug>

		./$SCRIPT -F auth -host 10.10.10.1 -port 1812 -TIMEOUT 8 -SECRET testing123 -RADIUSATTR "User-Name;NAS-Port-Id;ADSL-Agent-Circuit-Id;NAS-IP-Address" \
		-ATTRIBUTESVALUES "alex;pw-285:102;'10.13.3.22 eth_1/0/14';10.10.10.1" -CLIENT /usr/bin/radclient -W 5 -C 10 -DEBUG --delimiter ';'

		./$SCRIPT -Function status -host 192.168.34.2 -port 1812 -TIMEOUT 8 -secret testing123 -CLIENT /usr/bin/radclient -WARNING 1 -CRITICAL 8 --DEBUG

		./$SCRIPT -FUNC acct -h 10.10.10.1 -p 1813 -T 8 -S testing123 -radattributes <string of comma separated radius attributes>
		-ATTRIBUTESVALUES <string of comma separated Values for above passed in RADIUSATTRIBUTES> -CLIENT /usr/bin/radclient -W 5 -C 10

		./$SCRIPT -Function status -host 192.168.34.2 -port 1812 -TIMEOUT 8 -secret testing123 -CLIENT /usr/bin/radclient -WARNING 1 -CRITICAL 8 --DEBUG

		./$SCRIPT --help
		./$SCRIPT --version

-|--f|F|FUN|FUNCTION|function   	Function input is MANDATORY. Can be either auth, acct or status. Use function AUTH to send an authentication packet
					(Access-Request), function ACCT to send an accounting packet (Accounting-Request), function STATUS to send an status 
					packet (Status-Server).
					(No DEFAULT)"
				
-|--h|H|host|HOST			IP to radius server to query
					(DEFAULT localhost)

-|--p|P|port|PORT			Port on radius server to query
					(Default is 1812)

-|--t|T|time|TIME|timeout		Wait timeout seconds before deciding that the NAS has not responded to a request, and re-sending the packet.  
					(DEFAULT 8).

-|--s|S|secret|SECRET			The shared secret for this client.  It needs to be defined on the radius server side too, for the IP address 
					you are  sending  the  radius packets from 
					(DEFAULT "testing123")

-|--r|R|rad|RAD|radius|RADIUS|radiusattributes|RADIUSATTRIBUTES 	string of comma separated radius attributes.(Delimiter is default "," unless changed 
									by passing in the flag -|--DELIMITER see section delimiter below for details)
									i.e "User-Name,NAS-Port-Id,ADSL-Agent-Circuit-Id,NAS-IP-Address". AS A HABIT make sure to 
									double quote "" this string list into the script.
									(DEFAULT "Message-Authenticator")

-|--a|A|attribute|ATTRIBUTE|attributevalues|ATTRIBUTESVALUES		string of comma separated Values for above passed in RADIUSATTRIBUTES(Delimiter is default 
									"," unless changed by passing in the flag -|--DELIMITER see section delimiter below for details)
									i.e alex,pw-285:102,"10.13.3.22 eth_1/0/14",10.10.10.1. AS A HABIT make sure to double quote "" 
									this string list into the script.
									(DEFAULT 0x00)
-|--del|delimiter			In some cases the RADIUS Attributes values one needs to pass on to this script may contain default delimiter comma ","
					in its string values. Like in string holders like Calling-Station-Id, ADSL-Agent-Circuit-Id or ADSL-Agent-Remote-Id etc. 
					And since we don't want to split those string values in the wrong places this is where one can change what delimiter is to be used.
					DON'T forget to double quote your delimiter to the program like --delim ";" or -DEL ';'

-|--cl|CL|client|CLIENT			Path to "radclient" to use for the radius query i.e /usr/bin/radclient
					(DEFAULT "/usr/bin/radclient")

-|--w|W|warn|WARN|warning|WARNING       This will tell Nagios when to send a WARNING message. This value can only be specified as a integer, no decimals accepted.
                                        WARNING Threshold is in seconds, and if the respons time from the radius server exceeds Warning threshold
					then the program will exit with WARNING exit($ERRORS{'WARNING'});
                                        (DEFAULT 3 sec)

-|--c|C|crit|CRIT|critical|CRITICAL     This will tell Nagios when to send a CRITICAL message. This value can only be specified as a integer, no decimals accepted.
                                        CRITICAL Threshold is in seconds and if the respons time from the radius server exceeds CRITICAL threshold
					then the program will exit with WARNING exit($ERRORS{'CRITICAL'});
                                        (DEFAULT 7 sec )

-|--d|D|DEBUG|debug        : Enable debugging (DEFAULT disabled)

-|--he|HE|help|HELP     Prints this help screen

-|--v|V|VERSION|version Prints program version

                        INFO: NEW in version 1.0.2 is that CRITCAL THRESHOLDS is checked first. The scripts now gives a critical EXIT if radclient exits with something else than 0
			This was changed because people wanted to get alarms if passed in radius secret or syntax was wrong, and not only if radius server didn't respond in time.

                        Also only use the debug flag from the CLI Nagios may be very confused by it.
                        If you find any BUGs or have a suggestion on a feature or improvements then please drop a line to cocoon.is\@gmail.com
                        
                        IMPORTANT!! For this scripts to work with Nagios! This script needs to be able to find nagios supplied utils.pm file.
                        Edit this file at the top of the file change "use lib qw( /usr/local/nagios/libexec );" to point to where you Nagios
                        installation installed utils.pm.        
                        IF you get errors looking like
                        "Global symbol "%ERRORS" requires explicit package name" Then it is a sure sign that your path to utils.pm is wrong.

			Values of radclient flags -c and -r are hardcoded in the script if one needs to change those VALUES then just edit this file and 
			change where \$RADIUS_RESENDS = "1" and/or \$RADIUS_SENDS = "1" to whatever values is needed.
 
USAGE
   exit 1;
}

